<?php declare(strict_types = 1);

namespace Mall\CronModule\Presenters;

use Mall\Model\Sync\SyncCategories;
use Mall\Model\Sync\SyncLabels;
use Mall\Model\Sync\SyncOrders;

class DownloadPresenter extends BasePresenter
{
	/** @var SyncCategories|null @inject */
	public ?SyncCategories $syncCategories = null;

	/** @var SyncLabels|null @inject */
	public ?SyncLabels $syncLabels = null;

	/** @var SyncOrders|null @inject */
	public ?SyncOrders $syncOrders = null;

	public function actionMallCategories()
	{
		set_time_limit(1000);
		ini_set('memory_limit', '2048M');
		try {
			$this->syncCategories->downloadCategories();
			$this->responseOk();
		} catch (\Exception $e) {
			$this->responseError($e->getMessage());
		}

		exit;
	}

	public function actionMallLabels()
	{
		try {
			set_time_limit(300);
			ini_set('memory_limit', '2048M');
			$this->syncLabels->downloadLabels();
			$this->responseOk();
		} catch (\Exception $e) {
			$this->responseError($e->getMessage());
		}

		exit;
	}

	public function actionMallNewOrders()
	{
		try {
			set_time_limit(300);
			ini_set('memory_limit', '2048M');
			$this->syncOrders->downloadNew();
			$this->responseOk();
		} catch (\Exception $e) {
			$this->responseError($e->getMessage());
		}

		exit;
	}

	public function actionMissingCommissions()
	{
		try {
			set_time_limit(300);
			ini_set('memory_limit', '2048M');
			$this->syncOrders->downloadMissingCommissions();
			$this->responseOk();
		} catch (\Exception $e) {
			$this->responseError($e->getMessage());
		}

		exit;
	}
}
