<?php declare(strict_types = 1);

namespace Mall\CronModule\Presenters;

use Core\Model\Entities\EntityManagerDecorator;
use Mall\Model\Entities\MallOrder;
use Mall\Model\MallClients;
use Mall\Model\Services\MallSellersService;
use Mall\Model\Sync\SyncDeliveries;
use Mall\Model\Sync\SyncProduct;
use Mall\Model\Sync\SyncTransports;
use Tracy\Debugger;

class SyncPresenter extends BasePresenter
{
	/** @var SyncProduct|null @inject */
	public ?SyncProduct $syncProduct = null;

	/** @var SyncTransports|null @inject */
	public ?SyncTransports $syncTransports = null;

	/** @var SyncDeliveries|null @inject */
	public ?SyncDeliveries $syncDeliveries = null;

	/** @var EntityManagerDecorator|null @inject */
	public ?EntityManagerDecorator $em = null;

	/** @var MallSellersService|null @inject */
	public ?MallSellersService $mallSellersService = null;

	/** @var MallClients|null @inject */
	public ?MallClients $mallClients = null;

	public function actionSendTest($id)
	{
		try {
			$this->syncProduct->processProducts([$id]);
			$this->responseOk();
		} catch (\Exception $e) {
			$this->responseError($e->getMessage());
		}

		exit;
	}

	public function actionSetCountry(): void
	{
		foreach ($this->em->getRepository(MallOrder::class)->createQueryBuilder('mo')
			         ->addSelect('o, s')
			         ->innerJoin('mo.order', 'o')
			         ->innerJoin('o.site', 's')
			         ->where('mo.country IS NULL')
			         ->getQuery()->getResult() as $mo) {
			foreach ($this->mallSellersService->getExisting() as $seller) {
				if (in_array($mo->getOrder()->site->getIdent(), $seller->seller->getSitesIdent())) {
					$mo->mallClient = $this->mallClients->getClient($seller->country);
					$this->em->getConnection()->executeStatement("UPDATE mall__order SET country = ? WHERE order_id = ?", [
						$mo->mallClient->getCountry(),
						$mo->getOrder()->getId(),
					]);

					break;
				}
			}
		}
	}

	public function actionUpdateAll(): void
	{
		set_time_limit(1200);
		ini_set('memory_limit', '4G');
		try {
			$this->syncProduct->processAll();
			$this->responseOk();
		} catch (\Exception $e) {
			$this->responseError($e->getMessage());
		}

		exit;
	}

	public function actionUpdateAllAvailabilities(): void
	{
		set_time_limit(1200);
		ini_set('memory_limit', '2G');
		try {
			$this->syncProduct->processAllAvailabilities();
			$this->responseOk();
		} catch (\Exception $e) {
			$this->responseError($e->getMessage());
		}

		exit;
	}

	public function actionCheckVariants(): void
	{
		set_time_limit(1200);
		ini_set('memory_limit', '2048M');
		try {
			$this->syncProduct->checkVariants();
			$this->responseOk();
		} catch (\Exception $e) {
			$this->responseError($e->getMessage());
		}

		exit;
	}

	public function actionDeliveries()
	{
		try {
			$this->syncDeliveries->sync();
			$this->responseOk();
		} catch (\Exception $e) {
			$this->responseError($e->getMessage());
		}

		exit;
	}

	public function actionCreateMap()
	{
		set_time_limit(300);
		ini_set('memory_limit', '2048M');

		try {
			$data = $this->syncProduct->createMap();
			$this->responseData([
				'addedProducts' => $data['products'] ?? 0,
				'addedVariants' => $data['variants'] ?? 0,
				'message'       => $data['message'] ?? '',
			]);
		} catch (\Exception $e) {
			$this->responseError($e->getMessage());
		}

		exit;
	}
}
