<?php declare(strict_types = 1);

namespace Mall\DI;

use Core\DI\CompilerExtension;
use Nette;

class MallExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Mall' => 'Mall\*Module\Presenters\*Presenter']);
		$builder = $this->getContainerBuilder();

		$eventManager = $builder->getDefinition('dbal.eventManager');
		$eventManager->addSetup('?->addEventListener(?, ?)', ['@self', ['onFlush', 'postUpdate', 'postRemove'],
			'mall.subscribers.productSubscriber']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods['initialize'];
		$builder = $this->getContainerBuilder();

		$init->addBody('Mall\Model\MallConfig::setParams($this->parameters[\'mall\']);');
	}
}
