<?php declare(strict_types = 1);

namespace Mall\FrontModule\Model\Subscribers;

use EshopOrders\FrontModule\Model\Event\OrderEvent;
use Mall\Model\Subscribers\ProductSubscriber;
use Mall\Model\Sync\SyncProduct;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderSubscriber implements EventSubscriberInterface
{
	protected SyncProduct $syncProduct;

	public function __construct(SyncProduct $syncProduct)
	{
		$this->syncProduct = $syncProduct;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess' => ['orderOnSuccess', 80],
		];
	}

	public function orderOnSuccess(OrderEvent $event): void
	{
		$order = $event->order;

		foreach ($order->getOrderItems() as $orderItem) {
			if (!$orderItem->getProduct())
				continue;

			ProductSubscriber::$updateQuantity[] = $orderItem->getProductId();
		}
	}
}
