<?php declare(strict_types = 1);

namespace Mall\Model\Consumers;

use Bunny\Message;
use Contributte\RabbitMQ\Consumer\IConsumer;
use Mall\Model\MallLogger;
use Mall\Model\Sync\SyncProduct;
use Nette\Utils\Json;

class UpdateConsumer implements IConsumer
{
	protected SyncProduct $syncProduct;

	public function __construct(SyncProduct $syncProduct)
	{
		$this->syncProduct = $syncProduct;
	}

	public function consume(Message $message): int
	{
		$data    = Json::decode($message->content, Json::FORCE_ARRAY);
		$headers = $message->headers;

		MallLogger::log("Product update - " . $message->content, 'rabbitMq');

		$ids = $data['ids'] ?? null;

		if ($ids) {
			$this->syncProduct->processProducts($ids);
		}

		return IConsumer::MESSAGE_ACK;
	}

}
