<?php declare(strict_types = 1);

namespace Mall\Model\Dao\Product;

use Mall\Model\ProductHelper;

class Availability
{
	const ACTIVE         = 'A';
	const INACTIVE       = 'N';
	const NOT_FOR_RESALE = 'X';

	public string $status;

	public int $in_stock = 0;

	public function __construct(string $status, int $in_stock)
	{
		$this->setStatus($status);
		$this->in_stock = $in_stock;
	}

	public function setStatus(string $status): self
	{
		if (!ProductHelper::checkAvailabilityStatus($status))
			throw new \Exception("Status '$status' not found");

		$this->status = $status;

		return $this;
	}

	public function getData(): array
	{
		return [
			'status'   => $this->status,
			'in_stock' => $this->in_stock,
		];
	}
}
