<?php declare(strict_types = 1);

namespace Mall\Model\Dao\Product;

abstract class BaseProduct
{
	public string $shortdesc;

	public string $longdesc;

	public function setShortDesc($string): self
	{
		$this->shortdesc = strip_tags($string);

		return $this;
	}

	public function getData()
	{
		$fn = function($object) use (&$fn) {
			$data = [];

			foreach (get_object_vars($object) as $k => $v) {
				if ($k == 'eshopId')
					continue;
				if (is_array($v)) {
					foreach ($v as $k2 => $v2) {
						if (is_object($v2)) {
							$data[$k][$k2] = $fn($v2);
						} else {
							$data[$k][$k2] = $v2;
						}
					}
				} else if (is_object($v)) {
					if ($v instanceof Variant) {
						$data[$k] = $v->getData();
					} else {
						$data[$k] = $fn($v);
					}
				} else {
					$data[$k] = $v;
				}
			}

			return $data;
		};

		return $fn($this);
	}
}
