<?php declare(strict_types = 1);

namespace Mall\Model\Dao\Product;

use Nette\Utils\DateTime;

class Label
{
	public string $label;

	public string $from;

	public string $to;

	public function __construct(string $label, \DateTimeInterface $from, \DateTimeInterface $to)
	{
		$this->label = $label;
		$this->setFrom($from);
		$this->setTo($to);
	}

	public function setFrom(\DateTimeInterface $from): self
	{
		$this->from = $from->format('Y-m-d H:i:s');

		return $this;
	}

	public function setTo(\DateTimeInterface $to): self
	{
		$this->to = $to->format('Y-m-d H:i:s');

		return $this;
	}
}
