<?php declare(strict_types = 1);

namespace Mall\Model\Dao\Product;

class Promotion
{
	public float $price;

	public string $from;

	public string $to;

	public function __construct(float $price, \DateTimeInterface $from, \DateTimeInterface $to)
	{
		$this->price = $price;
		$this->setFrom($from);
		$this->setTo($to);
	}

	public function setFrom(\DateTimeInterface $from): self
	{
		$this->from = $from->format('Y-m-d H:i:s');

		return $this;
	}

	public function setTo(\DateTimeInterface $to): self
	{
		$this->to = $to->format('Y-m-d H:i:s');

		return $this;
	}
}
