<?php declare(strict_types = 1);

namespace Mall\Model\Dao\Product;

use Mall\Model\MallConfig;
use Mall\Model\ProductHelper;

class Variant extends BaseProduct
{
	public string $id;

	public $eshopId;

	public string $title;

	public int $priority = 1;

	public ?int $barcode = null;

	public bool $isBase = false;

	public float $price;

	public ?float $purchase_price = null;

	public ?float $rpp = null;

	protected array $parameters = [];

	/** @var Media[] */
	protected array $media = [];

	/** @var Promotion[] */
	protected array $promotions = [];

	/** @var Label[] */
	protected array $labels = [];

	public Availability $availability;

	protected array $recommended = [];

	public int $delivery_delay = 1;

	public bool $free_delivery = false;

	protected string $package_size = Product::PACKAGE_SIZE_SMALLBOX;

	public bool $mallbox_allowed = false;

	public ?string $partner_title = null;

	public function __construct(string $id, string $title, float $price, string $shortdesc, string $longdesc, Availability $availability)
	{
		$this->id           = $id;
		$this->title        = $title;
		$this->price        = $price;
		$this->longdesc     = $longdesc;
		$this->availability = $availability;
		$this->setShortDesc($shortdesc);
	}

	public function addParameter(string $key, string $value): self
	{
		$forReplace = MallConfig::load('paramValueReplaces')[$value] ?? null;
		if ($forReplace)
			$value = $forReplace;

		$this->parameters[$key] = $value;

		return $this;
	}

	public function addMedia(Media $media): self
	{
		$this->media[] = $media;

		return $this;
	}

	public function addPromotion(Promotion $promotion): self
	{
		$this->promotions[] = $promotion;

		return $this;
	}

	public function addLabel(Label $label): self
	{
		$this->labels[] = $label;

		return $this;
	}

	public function setPackageSize(string $packageSize): self
	{
		if (!ProductHelper::checkPackageSize($packageSize))
			throw new \Exception("Package size '$packageSize' not found");

		$this->package_size = $packageSize;

		return $this;
	}

	public function addRecommended(string $productId): self
	{
		$this->recommended[] = $productId;

		return $this;
	}
}
