<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__category")
 */
class Category
{
	use TId;

	/**
	 * @ORM\Column(name="mall_id", type="string", length=255, nullable=false)
	 */
	protected string $mallId;

	/**
	 * @ORM\Column(name="country", type="string", length=255, nullable=false)
	 */
	protected string $country;

	/**
	 * @ORM\Column(name="title", type="string", length=255, nullable=true)
	 */
	protected ?string $title = null;

	/**
	 * @var CategoryMap[]|ArrayCollection
	 * @ORM\OneToMany(targetEntity="CategoryMap", mappedBy="mallCategory", indexBy="category_id")
	 */
	public $mapped;

	/**
	 * @var Param[]|ArrayCollection
	 * @ORM\OneToMany(targetEntity="Param", mappedBy="category", indexBy="mall_id")
	 */
	public $params;

	/**
	 * @ORM\Column(name="is_available", type="smallint", nullable=false, options={"default": 0, "unsigned": true})
	 */
	public int $isAvailable = 0;

	public function __construct(string $mallId, string $country, ?string $title = null)
	{
		$this->mallId  = $mallId;
		$this->country = $country;
		$this->title   = $title;
		$this->mapped  = new ArrayCollection();
		$this->params  = new ArrayCollection();
	}

	public function getMallId(): string { return $this->mallId; }

	public function getCountry(): string { return $this->country; }

	public function getTitle(): ?string { return $this->title; }
}
