<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__label")
 */
class Label
{
	use TId;

	/**
	 * @ORM\Column(name="mall_id", type="string", length=255, nullable=false)
	 */
	protected string $mallId;

	/**
	 * @ORM\Column(name="country", type="string", length=255, nullable=false)
	 */
	protected string $country;

	/**
	 * @ORM\Column(name="title", type="string", length=255, nullable=true)
	 */
	protected ?string $title = null;

	/**
	 * @ORM\Column(name="`show`", type="smallint", length=1, options={"default": 0})
	 */
	public int $show = 0;

	public function __construct(string $mallId, string $country, ?string $title = null)
	{
		$this->mallId  = $mallId;
		$this->country = $country;
		$this->title   = $title;
	}

	public function getMallId(): string { return $this->mallId; }

	public function getCountry(): string { return $this->country; }

	public function getTitle(): ?string { return $this->title; }
}
