<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Order;
use Gedmo\Mapping\Annotation as Gedmo;
use Mall\Model\Dao\MallClient;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__order")
 */
class MallOrder
{
	const STATUS_OPEN      = 'open';
	const STATUS_SHIPPING  = 'shipping';
	const STATUS_SHIPPED   = 'shipped';
	const STATUS_DELIVERED = 'delivered';
	const STATUS_RETURNED  = 'returned';
	const STATUS_CANCELED  = 'canceled';
	const STATUS_LOST      = 'lost';
	const STATUS_STORNO    = 'storno';

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Order $order;

	/**
	 * @ORM\Column(name="mall_id", type="string", nullable=false)
	 */
	protected string $mallId;

	/**
	 * @ORM\Column(name="country", type="string", length=2, nullable=true)
	 */
	public ?string $country = null;

	/**
	 * @ORM\Column(name="last_status", type="string", nullable=false, options={"default": "open"})
	 */
	public string $lastStatus = self::STATUS_OPEN;

	/**
	 * @ORM\Column(name="tracking_number", type="string", nullable=true)
	 */
	public ?string $trackingNumber = null;

	/**
	 * @ORM\Column(name="tracking_url", type="string", nullable=true)
	 */
	public ?string $trackingUrl = null;

	/**
	 * @ORM\Column(name="exported", type="datetime", nullable=true)
	 */
	protected ?\DateTimeInterface $exported;

	public ?MallClient $mallClient = null;

	public function __construct(Order $order, string $mallId)
	{
		$this->order  = $order;
		$this->mallId = $mallId;
	}

	public function getOrder(): Order { return $this->order; }

	public function getMallId(): string { return $this->mallId; }

	public function getExported(): ?\DateTimeInterface { return $this->exported; }

	public function export(): void { $this->exported = new \DateTime(); }
}
