<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__product_promotion")
 */
class ProductPromotion
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Product $product;

	/**
	 * @ORM\Column(name="country", type="string", length=255, nullable=false)
	 */
	protected string $country;

	/**
	 * @ORM\Column(name="price", type="decimal", precision=10, scale=2)
	 */
	public $price;

	/**
	 * @ORM\Column(name="`from`", type="datetime")
	 */
	public \DateTimeInterface $from;

	/**
	 * @ORM\Column(name="`to`", type="datetime")
	 */
	public \DateTimeInterface $to;

	public function __construct(Product $product, string $country, $price, \DateTimeInterface $from, \DateTimeInterface $to)
	{
		$this->product = $product;
		$this->country = $country;
		$this->price   = $price;
		$this->from    = $from;
		$this->to      = $to;
	}

}
