<?php declare(strict_types = 1);

namespace Mall\Model;

use Currency\AdminModule\Model\Currencies;
use Mall\Model\Dao\MallClient;

class MallClients
{
	protected ?array $cClients = null;

	protected Currencies $currencies;

	public function __construct(Currencies $currencies)
	{
		$this->currencies = $currencies;
	}

	protected function loadClients(): void
	{
		if ($this->cClients === null) {
			$this->cClients = [];

			foreach (MallConfig::load('clients') as $country => $config) {
				$client               = new MallClient($country, $config['clientId'], $config['endPoint'], $config['locale'], $config['eshop']);
				$client->defaultStage = $config['defaultStage'];
				$client->imagesDomain = $config['imagesDomain'];
				$client->currency     = $config['currency'];
				$client->mallDomain   = $config['mallDomain'];
				$client->ulozenka     = (int) $config['ulozenka'];
				$client->invoiceId    = $config['invoiceId'];
				$client->testOrders   = (bool) $config['testOrders'];

				if ($country === 'sk') {
					$client->currencyEntity = $this->currencies->getByShop('mallsk')[strtoupper($client->currency)] ?? null;
				}

				$this->cClients[$country] = $client;
			}
		}
	}

	/**
	 * @return MallClient[]
	 */
	public function getClients(): array
	{
		if ($this->cClients === null)
			$this->loadClients();

		return $this->cClients;
	}

	public function getClient(string $country): ?MallClient
	{
		return $this->getClients()[$country] ?? null;
	}
}
