<?php declare(strict_types = 1);

namespace Mall\Model;

use Nette\Utils\DateTime;
use Nette\Utils\FileSystem;
use Tracy\Debugger;

class MallLogger
{
	public static function log($e, ?string $country = null): void
	{
		FileSystem::createDir(LOG_DIR . DS . 'mall');
		Debugger::log($e, 'mall/' . (new DateTime())->format('Y-m-d') . ($country ? '-' . $country : ''));
	}

	public static function logResponse(array $response, ?string $country = null): void
	{
		FileSystem::createDir(LOG_DIR . DS . 'mall');

		$msg = $response['date'];
		if (isset($response['errorCodes']))
			$msg = $response['errorCodes'];
		else if (isset($response['result']['message']))
			$msg = $response['result']['message'];

		Debugger::log($msg, 'mall/' . (new DateTime())->format('Y-m-d') . ($country ? '-' . $country : ''));
	}
}
