<?php declare(strict_types = 1);

namespace Mall\Model\Publishers;

use Contributte\RabbitMQ\Producer\Producer;
use Nette\Utils\DateTime;
use Nette\Utils\Json;

class MallPublisher
{
	protected Producer $producer;

	public function __construct(Producer $producer)
	{
		$this->producer = $producer;
	}

	public function updateQuantity(array $ids): void
	{
		file_put_contents(TMP_DIR . '/test.log', "Quantity update publisher " . (new DateTime())->format('Y-m-d H:i:s') . " \r\n", FILE_APPEND);
		$json    = Json::encode([
			'ids' => $ids,
		]);
		$headers = [];

		$this->producer->publish($json, $headers, 'quantity');
	}

	public function updateProduct(array $ids): void
	{
		file_put_contents(TMP_DIR . '/test.log', "Product update publisher " . (new DateTime())->format('Y-m-d H:i:s') . " \r\n", FILE_APPEND);
		$json    = Json::encode([
			'ids' => $ids,
		]);
		$headers = [];

		$this->producer->publish($json, $headers, 'update');
	}

	public function updatePrice(array $ids): void
	{
		file_put_contents(TMP_DIR . '/test.log', "Price update publisher " . (new DateTime())->format('Y-m-d H:i:s') . " \r\n", FILE_APPEND);
		$json    = Json::encode([
			'ids' => $ids,
		]);
		$headers = [];

		$this->producer->publish($json, $headers, 'price');
	}

}
