<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\Spedition;
use Mall\Model\Entities\Delivery;

/**
 * @method Delivery get($id)
 * @method Delivery[] getAll()
 * @method Delivery getReference($id)
 */
class DeliveriesService extends BaseEntityService
{
	protected $entityClass = Delivery::class;

	protected ?array $existing = null;

	public function checkExist(string $country, string $code): bool
	{
		return isset($this->getExisting()[$country][$code]);
	}

	/**
	 * @return Delivery[]
	 */
	public function getExisting(): array
	{
		if ($this->existing === null) {
			$this->existing = [];

			foreach ($this->getAll() as $row)
				$this->existing[$row->getCountry()][$row->getCode()] = $row;
		}

		return $this->existing;
	}

	public function setEshopSpedition(string $country, string $code, $eshopSpedition): bool
	{
		try {
			/** @var Delivery $delivery */
			$delivery = $this->getEr()->findOneBy(['country' => $country, 'code' => $code]);

			if ($delivery) {
				$delivery->eshopSpedition = $eshopSpedition === '' ? null : $this->em->getReference(Spedition::class, $eshopSpedition);
				$this->em->persist($delivery);
				$this->em->flush($delivery);

				return true;
			}
		} catch (\Exception $e) {
		}

		return false;
	}
}
