<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Core\Model\Helpers\BaseEntityService;
use Mall\Model\Entities\Label;

/**
 * @method Label get($id)
 * @method Label[] getAll()
 * @method Label getReference($id)
 */
class LabelsService extends BaseEntityService
{
	protected $entityClass = Label::class;

	public function setShow(int $id, int $show = 1): bool
	{
		try {
			$ref       = $this->getReference($id);
			$ref->show = $show;

			$this->em->persist($ref);
			$this->em->flush();

			return true;
		} catch (\Exception $e) {
			bdump($e);
		}

		return false;
	}

	public function getVisibleArray(): array
	{
		$result = [];

		foreach ($this->getEr()->createQueryBuilder('l')
			         ->andWhere('l.show = 1')
			         ->getQuery()->getArrayResult() as $row)
			$result[$row['country']][$row['mallId']] = $row;

		return $result;
	}
}
