<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Core\Model\Helpers\Strings;
use Mall\Model\Dao\MallClient;
use Nette\Caching\Cache;
use Nette\Caching\Storage;

class MallApiBrands extends MallApiBaseService
{
	const CACHE_NAMESPACE = 'mallApiBrands';

	protected string $baseUrl = 'brands';

	protected ?array $cBrands = null;

	protected Cache $cache;

	public function __construct(Storage $storage)
	{
		$this->cache = new Cache($storage, self::CACHE_NAMESPACE);
	}

	public function getAllBrands(MallClient $client): array
	{
		$key = $client->getCountry();
		if ($this->cBrands[$key] === null) {
			$this->cBrands[$key] = $this->cache->load($key, function(&$dep) use ($client) {
				$dep    = [Cache::EXPIRATION => '3 days'];
				$tmp    = [];
				$brands = $this->sendRequest($client);

				if ($brands) {
					foreach ($brands as $row) {
						$tmp[$row['brand_id']] = $row['title'];
					}
				}

				return $tmp;
			});
		}

		return $this->cBrands[$key];
	}

	public function findBrand(MallClient $client, string $title): ?string
	{
		$title = Strings::lower($title);
		foreach ($this->getAllBrands($client) as $brandId => $brandTitle) {
			if ($title === Strings::lower($brandTitle))
				return $brandId;
		}

		return null;
	}
}
