<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Mall\Model\Dao\MallClient;

class MallApiCategories extends MallApiBaseService
{
	protected string $baseUrl = 'categories';

	public function getAllCategories(MallClient $client): array
	{
		$categories = $this->sendRequest($client);
		$result     = [];

		if ($categories) {
			foreach ($categories as $row) {
				$result[$row['category_id']] = $row['title'];
			}
		}

		return $result;
	}

	public function getAllParameters(MallClient $client): array
	{
		$result = [];

		foreach ($this->getAllCategories($client) as $catId => $catName) {
			$result[$catId] = $this->getParameters($client, $catId);
		}

		return $result;
	}

	public function getParameters(MallClient $client, string $categoryId): array
	{
		$parameters = $this->sendRequest($client, '/' . $categoryId . '/params');
		$result     = [];

		if ($parameters) {
			foreach ($parameters as $row) {
				$result[$row['param_id']] = [
					'title' => $row['title'],
					'unit'  => $row['unit'],
				];
			}
		}

		return $result;
	}
}
