<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Mall\Model\Dao\MallClient;

class MallApiDeliveries extends MallApiBaseService
{
	protected string $baseUrl = 'deliveries';

	public function getIds(MallClient $client): array
	{
		return $this->sendRequest($client, 'partner')['ids'] ?? [];
	}

	public function getDetail(MallClient $client, string $code): array
	{
		return $this->sendRequest($client, 'partner/' . $code);
	}
}
