<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Mall\Model\Dao\MallClient;

class MallApiLabels extends MallApiBaseService
{
	protected string $baseUrl = 'labels';

	protected ?array $cLabels = null;

	public function getAllLabels(MallClient $client): array
	{
		$key = $client->getCountry();
		if ($this->cLabels[$key] === null) {
			$this->cLabels[$key] = [];
			$labels              = $this->sendRequest($client);

			if ($labels) {
				foreach ($labels as $row) {
					$this->cLabels[$key][$row['id']] = $row['title'];
				}
			}
		}

		return $this->cLabels[$key];
	}
}
