<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Mall\Model\Dao\MallClient;
use Mall\Model\Entities\MallOrder;

class MallApiOrders extends MallApiBaseService
{
	protected string $baseUrl = 'orders';

	public function getOpenIds(MallClient $client): array
	{
		$this->method = 'GET';
		$orders       = $this->sendRequest($client, 'open');

		return $orders['ids'] ?? [];
	}

	public function getShippedBasic(MallClient $client): array
	{
		$this->method = 'GET';
		$orders       = $this->sendRequest($client, 'shipped', ['filter' => 'basic']);

		return $orders ?? [];
	}

	public function getDetail(MallClient $client, int $id): ?array
	{
		$this->method = 'GET';
		$detail       = $this->sendRequest($client, (string) $id);

		if ($client->testOrders && !$detail['test'])
			return [];

		return $detail;
	}

	public function setShipping(MallClient $client, string $mallId): bool
	{
		try {
			$this->method = 'PUT';
			$result       = $this->sendRequest($client, $mallId, [], [
				'confirmed' => true,
				'status'    => MallOrder::STATUS_SHIPPING,
			]);

			return $result === true;
		} catch (\Exception $e) {

		}

		return false;
	}

	public function setShipped(MallClient $client, string $mallId, ?string $trackingNumber = null, ?string $trackingUrl = null): bool
	{
		try {
			$this->method = 'PUT';

			$data = [
				'confirmed' => true,
				'status'    => MallOrder::STATUS_SHIPPED,
			];
			if ($trackingNumber) {
				$data['tracking_number'] = $trackingNumber;
			}
			if ($trackingUrl) {
				$data['tracking_url'] = $trackingUrl;
			}

			$result = $this->sendRequest($client, $mallId, [], $data);

			return $result === true;
		} catch (\Exception $e) {

		}

		return false;
	}

	public function setDelivered(MallClient $client, string $mallId, ?\DateTimeInterface $deliveredAt = null): bool
	{
		try {
			$this->method = 'PUT';

			$data = [
				'confirmed' => true,
				'status'    => MallOrder::STATUS_DELIVERED,
			];
			if ($deliveredAt) {
				$data['delivered_at'] = $deliveredAt->format('Y-m-d H:i:s');
			}

			$result = $this->sendRequest($client, $mallId, [], $data);

			return $result === true;
		} catch (\Exception $e) {

		}

		return false;
	}

	public function setCancelled(MallClient $client, string $mallId): bool
	{
		try {
			$this->method = 'PUT';

			$data = [
				'status' => MallOrder::STATUS_CANCELED,
			];

			$result = $this->sendRequest($client, $mallId, [], $data);

			return $result === true;
		} catch (\Exception $e) {

		}

		return false;
	}

	public function generateLabelPdf(MallClient $client, string $mallId): ?string
	{
		try {
			$this->method = 'POST';
			$result       = $this->sendRequest($client, '/labels', [], [
				'labels_type'     => 'pdf',
				'first_position'  => 1,
				'labels_per_page' => 1,
				'labels'          => [
					[
						'order_id'     => (int) $mallId,
						'parcel_count' => 1,
					],
				],
			]);
			bdump($result, 'generate Label');

			return $result['labels_raw'] ?? null;
		} catch (\Exception $e) {

		}

		return null;
	}
}
