<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Mall\Model\Dao\MallClient;

class MallApiTransports extends MallApiBaseService
{
	protected string $baseUrl = 'v2/transports/warehouses';

	public function getWareHouses(MallClient $client): array
	{
		$res = $this->sendRequest($client);

		$warehouses = [];
		if ($res && isset($res['items'])) {
			foreach ($res['items'] as $v)
				$warehouses[$v['id']] = $v;
		}

		return $warehouses;
	}

	public function getTransports(MallClient $client, $warehouseId): array
	{
		$res = $this->sendRequest($client, '/' . $warehouseId . '/transports');

		$transports = [];
		if ($res && isset($res['items'])) {
			foreach ($res['items'] as $v) {
				if (!$v['enabled'])
					continue;

				$transports[$v['transport']['id']] = [
					'id'        => $v['id'],
					'transport' => $v['transport'],
				];
			}
		}

		return $transports;
	}

}
