<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\Seller;
use Mall\Model\Entities\MallSeller;

/**
 * @method MallSeller get($id)
 * @method MallSeller[] getAll()
 * @method MallSeller getReference($id)
 */
class MallSellersService extends BaseEntityService
{
	protected $entityClass = MallSeller::class;

	protected ?array $existing = null;

	public function checkExist(string $country): bool
	{
		return isset($this->getExisting()[$country]);
	}

	/**
	 * @return MallSeller[]
	 */
	public function getExisting(): array
	{
		if ($this->existing === null) {
			$this->existing = [];

			foreach ($this->getAll() as $row)
				$this->existing[$row->country] = $row;
		}

		return $this->existing;
	}

	public function setEshopSeller(string $country, $seller): bool
	{
		try {
			/** @var MallSeller $mallSeller */
			$mallSeller = $this->getEr()->findOneBy(['country' => $country]);

			if (!$mallSeller)
				$mallSeller = new MallSeller($country);

			$mallSeller->seller = $seller === '' ? null : $this->em->getReference(Seller::class, $seller);
			$this->em->persist($mallSeller);
			$this->em->flush($mallSeller);

			return true;
		} catch (\Exception $e) {
		}

		return false;
	}
}
