<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query\Expr\Join;
use Mall\Model\Entities\Param;

/**
 * @method Param get($id)
 * @method Param[] getAll()
 * @method Param getReference($id)
 */
class ParametersService extends BaseEntityService
{
	protected $entityClass = Param::class;

	public function setFeature($paramId, $featureId): bool
	{
		try {
			if ($featureId === '')
				$featureId = null;

			$this->em->getConnection()->executeStatement("UPDATE {$this->em->getClassMetadata($this->entityClass)->getTableName()} SET feature = ? WHERE id = ?", [
				$featureId,
				$paramId,
			]);

			return true;
		} catch (\Exception $e) {
		}

		return false;
	}

	public function getByCategoryId(string $categoryId, string $country)
	{
		$result = [];

		foreach ($this->getEr()->createQueryBuilder('p')
			         ->select('p.mallId, p.feature')
			         ->innerJoin('p.category', 'c', Join::WITH, 'c.mallId = :catId AND c.country = :country')
			         ->andWhere('p.feature != \'\'')
			         ->setParameters([
				         'catId'   => $categoryId,
				         'country' => $country,
			         ])->getQuery()->getArrayResult() as $row) {
			$result[$row['feature']] = $row['mallId'];
		}

		return $result;
	}
}
