<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Core\Model\Helpers\BaseEntityService;
use Mall\Model\Entities\ProductForceToken;
use Mall\Model\ProductHelper;
use Mall\Model\Sync\SyncProduct;
use Nette\Localization\ITranslator;

/**
 * @method ProductForceToken get($id)
 * @method ProductForceToken[] getAll()
 * @method ProductForceToken getReference($id)
 */
class ProductForceTokenService extends BaseEntityService
{
	protected $entityClass = ProductForceToken::class;

	protected ITranslator $translator;

	protected SyncProduct $syncProduct;

	protected ProductHelper $productHelper;

	protected ?array $cLabels = null;

	public function __construct(ITranslator $translator, SyncProduct $syncProduct, ProductHelper $productHelper)
	{
		$this->translator    = $translator;
		$this->syncProduct   = $syncProduct;
		$this->productHelper = $productHelper;
	}

	public function confirmChange($id, $country): bool
	{
		try {
			$entity = $this->productHelper->findForceToken($id, $country);

			if (!$entity || $this->syncProduct->sendForceToken($country, $id, $entity->getForceToken()))
				return false;

			$entity->use();
			$this->em->persist($entity);
			$this->em->flush();

			return true;
		} catch (\Exception $e) {
		}

		return false;
	}

	public function getUnUsed(?string $country = null): array
	{
		$arr = [];

		$qb = $this->getEr()->createQueryBuilder('pft')
			->select('pft.created, pft.priceTo, pft.country, p.id, pt.name, pt.lang')
			->innerJoin('pft.eshopProduct', 'p')
			->innerJoin('p.productTexts', 'pt')
			->andWhere('pft.used IS NULL')
			->orderBy('pft.created', 'DESC');

		if ($country) {
			$qb->andWhere('pft.country = :country')
				->setParameter('country', $country);
		}

		foreach ($qb->getQuery()->getArrayResult() as $row) {
			if (isset($arr[$row['id']]) && $row['lang'] != $this->translator->getLocale())
				continue;

			$arr[$row['id']] = $row;
		}

		return $arr;
	}

	public function remove($id, $country)
	{
		try {
			$this->em->createQueryBuilder()->delete($this->entityClass, 'pft')
				->where('pft.eshopProduct = :eshopProduct')
				->andWhere('pft.country = :country')
				->setParameters([
					'eshopProduct' => $id,
					'country'      => $country,
				])->getQuery()->execute();
		} catch (\Exception $e) {
			return false;
		}

		return true;
	}

}
