<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Core\Model\Helpers\BaseEntityService;
use Mall\Model\Entities\ProductLabel;

/**
 * @method ProductLabel get($id)
 * @method ProductLabel[] getAll()
 * @method ProductLabel getReference($id)
 */
class ProductLabelsService extends BaseEntityService
{
	protected $entityClass = ProductLabel::class;

	protected ?array $cLabels = null;

	public function getForProduct(int $productId): array
	{
		if (!isset($this->cLabels[$productId])) {
			$this->cLabels[$productId] = [];
			$arr                       = [];

			foreach ($this->getEr()->createQueryBuilder('pl')
				         ->addSelect('l')
				         ->innerJoin('pl.label', 'l')
				         ->andWhere('pl.product = :product')
				         ->setParameters([
					         'product' => $productId,
				         ])->getQuery()->getArrayResult() as $row) {
				$arr[$row['label']['country']][$row['label']['mallId']] = $row;
			}

			$this->cLabels[$productId] = $arr;
		}

		return $this->cLabels[$productId];
	}
}
