<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Core\Model\Helpers\BaseEntityService;
use Mall\Model\Entities\ProductPromotion;

/**
 * @method ProductPromotion get($id)
 * @method ProductPromotion[] getAll()
 * @method ProductPromotion getReference($id)
 */
class ProductPromotionsService extends BaseEntityService
{
	protected $entityClass = ProductPromotion::class;

	protected ?array $cPromotions = null;

	public function getForProduct(int $productId): array
	{
		if (!isset($this->cPromotions[$productId])) {
			$this->cPromotions[$productId] = [];
			$arr                           = [];

			foreach ($this->getEr()->createQueryBuilder('pp')
				         ->andWhere('pp.product = :product')
				         ->setParameters([
					         'product' => $productId,
				         ])->getQuery()->getArrayResult() as $row) {
				$arr[$row['country']]['0'] = $row;
			}

			$this->cPromotions[$productId] = $arr;
		}

		return $this->cPromotions[$productId];
	}
}
