<?php declare(strict_types = 1);

namespace Mall\Model\Services;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\Product;

/**
 * @method Product get($id)
 * @method Product[] getAll()
 * @method Product getReference($id)
 */
class ProductService extends BaseEntityService
{
	protected $entityClass = Product::class;

	public function getAllIds(): array
	{
		$data = [];

		foreach ($this->em->getConnection()->fetchAllAssociative("SELECT id FROM eshop_catalog__product") as $row) {
			$data[$row['id']] = $row['id'];
		}

		return $data;
	}

	public function getAllOldIdsMap(): array
	{
		$data            = [];
		$defaultVariants = $this->getDefaultVariants();

		foreach ($this->em->getConnection()->fetchAllAssociative(
			"SELECT `section_key`, `value` FROM `core__extra_field` WHERE `section_name` = ? AND `key` = ?", [
			'eshopCatalogProduct', 'oldZurielId',
		]) as $row) {
			$data[$row['value']][$row['section_key']] = $row['section_key'];
		}

		foreach ($data as $oldId => $eshopIds) {
			if (count($eshopIds) > 1) {
				foreach ($eshopIds as $eshopId) {
					if (isset($defaultVariants[$eshopId])) {
						$data[$oldId] = $defaultVariants[$eshopId];
						continue 2;
					}
				}
			}

			$data[$oldId] = array_values($eshopIds)[0];
		}

		return $data;
	}

	public function getDefaultVariants(): array
	{
		$data = [];

		foreach ($this->em->getConnection()->fetchAllAssociative(
			"SELECT `product_id` FROM eshop_catalog__product_variant WHERE `is_default` = ?", [
			'1',
		],
		) as $row) {
			$data[$row['product_id']] = $row['product_id'];
		}

		return $data;
	}
}
