<?php declare(strict_types = 1);

namespace Mall\Model;

use Core\Model\Settings as CoreSettings;

class Settings
{
	const PREFIX = 'Mall_';

	protected CoreSettings $settings;

	public function __construct(CoreSettings $settings)
	{
		$this->settings = $settings;
	}

	public function syncEnabled(string $country): bool
	{
		return (bool) $this->settings->get(self::PREFIX . $country . 'EnableSync', false);
	}

	public function getDisabledManufacturers(string $country): array
	{
		return $this->settings->get(self::PREFIX . $country . 'DisableManufacturers', []);
	}
}
