<?php declare(strict_types = 1);

namespace Mall\Model\Subscribers;

use Contributte\Events\Extra\Event\Application\ResponseEvent;
use Contributte\Events\Extra\Event\Application\ShutdownEvent;
use Mall\Model\MallConfig;
use Mall\Model\Publishers\MallPublisher;
use Mall\Model\Sync\SyncProduct;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ApplicationSubscriber implements EventSubscriberInterface
{
	protected SyncProduct   $syncProduct;
	protected MallPublisher $mallPublisher;

	public function __construct(SyncProduct $syncProduct, MallPublisher $mallPublisher)
	{
		$this->syncProduct   = $syncProduct;
		$this->mallPublisher = $mallPublisher;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			ShutdownEvent::class => 'shutdown',
		];
	}

	public function shutdown(ShutdownEvent $event): void
	{
		if (MallConfig::load('useRabbitMq')) {
			if (!empty(ProductSubscriber::$updateFull)) {
				$this->mallPublisher->updateProduct(array_unique(ProductSubscriber::$updateFull));
			}

			if (!empty(ProductSubscriber::$updateQuantity)) {
				$this->mallPublisher->updateQuantity(array_unique(ProductSubscriber::$updateQuantity));
			}

			if (!empty(ProductSubscriber::$updatePrices)) {
				$this->mallPublisher->updatePrice(array_unique(ProductSubscriber::$updatePrices));
			}
		} else {
			if (!empty(ProductSubscriber::$updateFull)) {
				$this->syncProduct->processProducts(array_unique(ProductSubscriber::$updateFull));
			}

			if (!empty(ProductSubscriber::$updateQuantity)) {
				$this->syncProduct->processProductAvailabilities(array_unique(ProductSubscriber::$updateQuantity));
			}

			if (!empty(ProductSubscriber::$updatePrices)) {
				$this->syncProduct->processProductsPrices(array_unique(ProductSubscriber::$updatePrices));
			}
		}
	}
}
