<?php declare(strict_types = 1);

namespace Mall\Model\Sync;

use Core\Model\Entities\EntityManagerDecorator;
use Mall\Model\Entities\Category;
use Mall\Model\Entities\Param;
use Mall\Model\MallClients;
use Mall\Model\Services\CategoriesService;
use Mall\Model\Services\MallApiCategories;
use Mall\Model\Services\ParametersService;

class SyncCategories
{
	protected EntityManagerDecorator $em;

	protected MallClients $mallClients;

	protected MallApiCategories $mallCategories;

	protected CategoriesService $categoriesService;

	protected ParametersService $parametersService;

	public function __construct(EntityManagerDecorator $em, MallClients $mallClients, MallApiCategories $mallCategories,
	                            CategoriesService $categoriesService, ParametersService $parametersService)
	{
		$this->em                = $em;
		$this->mallClients       = $mallClients;
		$this->mallCategories    = $mallCategories;
		$this->categoriesService = $categoriesService;
		$this->parametersService = $parametersService;
	}

	public function downloadCategories(): void
	{
		$shopCategories = [];
		$shopParameters = [];

		foreach ($this->categoriesService->getAll() as $cat)
			$shopCategories[$cat->getCountry()][$cat->getMallId()] = $cat;

		foreach ($this->parametersService->getAll() as $param)
			$shopParameters[$param->getCategory()->getId()][$param->getMallId()] = $param;

		foreach ($this->mallClients->getClients() as $country => $client) {
			if (!isset($shopCategories[$country]))
				$shopCategories[$country] = [];

			$mallCategories = $this->mallCategories->getAllCategories($client);

			// Kategorie nove
			foreach (array_diff_key($mallCategories, $shopCategories[$country]) as $id => $title) {
				$entity = new Category($id, $country, $title);
				$this->em->persist($entity);
				$shopCategories[$country][$id] = $entity;
			}

			// Kategorie stare
			foreach (array_diff_key($shopCategories[$country], $mallCategories) as $entity) {
				$this->em->remove($entity);
			}

			$this->em->flush();

			//Parametry
			$mallParameters     = [];
			$categoryParameters = [];
			foreach ($this->categoriesService->getAvailableCategories($country) as $catMallId => $title) {
				$data = $this->mallCategories->getParameters($client, $catMallId);

				if (is_array($data)) {
					$mallParameters += $data;
					$catId          = $shopCategories[$country][$catMallId]->getId();

					if (!isset($shopParameters[$catId]))
						$shopParameters[$catId] = [];

					// Parametry nove
					foreach (array_diff_key($data, $shopParameters[$catId]) as $id => $v) {
						$entity = new Param($shopCategories[$country][$catMallId], $id, $v['title'], $v['unit']);
						$this->em->persist($entity);
						$shopParameters[$country][$id] = $entity;
					}

					// Parametry stare
					foreach (array_diff_key($shopParameters[$catId], $data) as $entity) {
						$this->em->remove($entity);
					}


					if (!isset($shopCategoryParam[$catMallId]))
						$shopCategoryParam[$catMallId] = [];

					foreach ($data as $k => $v) {
						$categoryParameters[$catMallId][$k] = $v;
					}
				}
			}

			$this->em->flush();
		}
	}
}
