<?php declare(strict_types = 1);

namespace Mall\Model\Sync;

use Core\Model\Entities\EntityManagerDecorator;
use Mall\Model\Entities\Delivery;
use Mall\Model\MallClients;
use Mall\Model\Services\DeliveriesService;
use Mall\Model\Services\MallApiDeliveries;
use Mall\Model\Services\MallApiTransports;

class SyncDeliveries
{
	protected EntityManagerDecorator $em;

	protected MallClients $mallClients;

	protected MallApiDeliveries $mallApiDeliveries;

	protected DeliveriesService $deliveriesService;

	protected MallApiTransports $mallApiTransports;

	public function __construct(EntityManagerDecorator $em, MallClients $mallClients, MallApiDeliveries $mallApiDeliveries,
	                            DeliveriesService      $deliveriesService, MallApiTransports $mallApiTransports)
	{
		$this->em                = $em;
		$this->mallClients       = $mallClients;
		$this->mallApiDeliveries = $mallApiDeliveries;
		$this->deliveriesService = $deliveriesService;
		$this->mallApiTransports = $mallApiTransports;
	}

	public function sync(): void
	{
		foreach ($this->mallClients->getClients() as $country => $client) {
			$apiTransports = [];
			foreach ($this->mallApiTransports->getWareHouses($client) as $wareHouseId => $wareHouse) {
				foreach ($this->mallApiTransports->getTransports($client, $wareHouseId) as $id => $transport) {
					$apiTransports[$id] = $transport;
				}
			}

			$apiDeliveries = array_flip($this->mallApiDeliveries->getIds($client));
			$exist         = $this->deliveriesService->getExisting()[$country] ?? [];
			$deleteCompare = [];
			foreach ($exist as $k => $v) {
				$deleteCompare[$k] = $k;
			}

			foreach (array_diff_key($apiDeliveries, $exist) as $code => $k) {
				$detail = $this->mallApiDeliveries->getDetail($client, (string) $code);

				$delivery = new Delivery((string) $code, $country, $detail['title'], (string) $detail['delivery_method_id']);
				$this->em->persist($delivery);

				$deleteCompare[$code] = $code;
			}

			foreach (array_diff_key($apiTransports, $exist) as $code => $k) {
				$delivery = new Delivery((string) $code, $country, $k['transport']['name'], (string) $k['id']);
				$this->em->persist($delivery);

				$deleteCompare[$code] = $code;
			}

			foreach (array_diff_key($exist, $deleteCompare) as $delivery) {
				$this->em->remove($delivery);
			}

			$this->em->flush();
		}
	}
}
