<?php declare(strict_types = 1);

namespace Mall\Model\Sync;

use Core\Model\Entities\EntityManagerDecorator;
use Mall\Model\Entities\Label;
use Mall\Model\MallClients;
use Mall\Model\Services\LabelsService;
use Mall\Model\Services\MallApiLabels;

class SyncLabels
{
	protected EntityManagerDecorator $em;

	protected MallClients $mallClients;

	protected MallApiLabels $mallApiLabels;

	protected LabelsService $labelsService;

	public function __construct(EntityManagerDecorator $em, MallClients $mallClients, MallApiLabels $mallApiLabels, LabelsService $labelsService)
	{
		$this->em            = $em;
		$this->mallClients   = $mallClients;
		$this->mallApiLabels = $mallApiLabels;
		$this->labelsService = $labelsService;
	}

	public function downloadLabels(): void
	{
		$shopLabels = [];

		foreach ($this->labelsService->getAll() as $label)
			$shopLabels[$label->getCountry()][$label->getMallId()] = $label;

		foreach ($this->mallClients->getClients() as $country => $client) {
			if (!isset($shopLabels[$country]))
				$shopLabels[$country] = [];

			$mallLabels = $this->mallApiLabels->getAllLabels($client);

			foreach (array_diff_key($mallLabels, $shopLabels[$country]) as $id => $title) {
				$entity = new Label($id, $country, $title);
				$this->em->persist($entity);
				$shopLabels[$country][$id] = $entity;
			}

			foreach (array_diff_key($shopLabels[$country], $mallLabels) as $entity) {
				$this->em->remove($entity);
			}

			$this->em->flush();
		}
	}
}
