<?php declare(strict_types = 1);

namespace Mall\Model\Sync;

use Core\Model\Entities\EntityManagerDecorator;
use Mall\Model\MallClients;
use Mall\Model\Services\MallApiTransports;
use Mall\Model\Services\OrdersService;

class SyncTransports
{
	protected EntityManagerDecorator $em;

	protected MallClients $mallClients;

	protected MallApiTransports $mallApiTransports;

	protected OrdersService $ordersService;

	public function __construct(EntityManagerDecorator $em, MallClients $mallClients, MallApiTransports $mallApiTransports,
	                            OrdersService $ordersService)
	{
		$this->em                = $em;
		$this->mallClients       = $mallClients;
		$this->mallApiTransports = $mallApiTransports;
		$this->ordersService     = $ordersService;
	}

	public function sync(): void
	{
		foreach ($this->mallClients->getClients() as $country => $client) {
			$this->mallApiTransports->loadBasic($client);
		}
	}
}
