<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200817103511 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE mall__category (id INT AUTO_INCREMENT NOT NULL, mall_id VARCHAR(255) NOT NULL, country VARCHAR(255) NOT NULL, title VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE mall__category_map (mall_id INT NOT NULL, category_id INT NOT NULL, INDEX IDX_8C4FBA5297E071 (mall_id), INDEX IDX_8C4FBA5212469DE2 (category_id), PRIMARY KEY(mall_id, category_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE mall__param (id INT AUTO_INCREMENT NOT NULL, category_id INT DEFAULT NULL, mall_id VARCHAR(255) NOT NULL, title VARCHAR(255) DEFAULT NULL, unit VARCHAR(255) DEFAULT NULL, feature VARCHAR(255) DEFAULT NULL, INDEX IDX_B96C6A3112469DE2 (category_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE mall__category_map ADD CONSTRAINT FK_8C4FBA5297E071 FOREIGN KEY (mall_id) REFERENCES mall__category (id)');
		$this->addSql('ALTER TABLE mall__category_map ADD CONSTRAINT FK_8C4FBA5212469DE2 FOREIGN KEY (category_id) REFERENCES eshop_catalog__category (id)');
		$this->addSql('ALTER TABLE mall__param ADD CONSTRAINT FK_B96C6A3112469DE2 FOREIGN KEY (category_id) REFERENCES mall__category (id)');

		$this->addSql('CREATE TABLE mall__label (id INT AUTO_INCREMENT NOT NULL, mall_id VARCHAR(255) NOT NULL, country VARCHAR(255) NOT NULL, title VARCHAR(255) DEFAULT NULL, `show` SMALLINT DEFAULT 0 NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE mall__product_label (id INT AUTO_INCREMENT NOT NULL, product_id INT DEFAULT NULL, label_id INT DEFAULT NULL, `from` DATETIME NOT NULL, `to` DATETIME NOT NULL, INDEX IDX_FDA9E93F4584665A (product_id), INDEX IDX_FDA9E93F33B92F39 (label_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE mall__product_promotion (id INT AUTO_INCREMENT NOT NULL, product_id INT DEFAULT NULL, country VARCHAR(255) NOT NULL, price NUMERIC(10, 2) NOT NULL, `from` DATETIME NOT NULL, `to` DATETIME NOT NULL, INDEX IDX_A26B7464584665A (product_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE mall__product_label ADD CONSTRAINT FK_FDA9E93F4584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id)');
		$this->addSql('ALTER TABLE mall__product_label ADD CONSTRAINT FK_FDA9E93F33B92F39 FOREIGN KEY (label_id) REFERENCES mall__label (id)');
		$this->addSql('ALTER TABLE mall__product_promotion ADD CONSTRAINT FK_A26B7464584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id)');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE mall__product_label DROP FOREIGN KEY FK_FDA9E93F33B92F39');
		$this->addSql('DROP TABLE mall__label');
		$this->addSql('DROP TABLE mall__product_label');
		$this->addSql('DROP TABLE mall__product_promotion');

		$this->addSql('ALTER TABLE mall__category_map DROP FOREIGN KEY FK_8C4FBA5297E071');
		$this->addSql('ALTER TABLE mall__param DROP FOREIGN KEY FK_B96C6A3112469DE2');
		$this->addSql('DROP TABLE mall__category');
		$this->addSql('DROP TABLE mall__category_map');
		$this->addSql('DROP TABLE mall__param');
	}
}
