<?php declare(strict_types = 1);

namespace MapPoints\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="map_points__map")
 * @ORM\Entity
 */
class Map
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public $title;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1})
	 */
	public $isPublished;

	/**
	 * @var string
	 * @ORM\Column(name="image", type="string", nullable=true)
	 */
	public $image;

	/**
	 * @var MapPoint[]
	 * @ORM\OneToMany(targetEntity="MapPoint", mappedBy="map")
	 */
	public $points;

	/**
	 * @var Group[]
	 */
	public $groups;

	public function __construct($title)
	{
		$this->title       = $title;
		$this->isPublished = 1;
		$this->points      = new ArrayCollection();
		$this->groups      = new ArrayCollection();
	}
}