<?php declare(strict_types = 1);

namespace MapPoints\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="map_points__map_point")
 * @ORM\Entity
 */
class MapPoint
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var Map
	 * @ORM\ManyToOne(targetEntity="Map", inversedBy="points")
	 * @ORM\JoinColumn(name="map_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $map;

	/**
	 * @var Point
	 * @ORM\ManyToOne(targetEntity="Point", inversedBy="maps")
	 * @ORM\JoinColumn(name="point_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $point;

	/**
	 * @var float
	 * @ORM\Column(name="pos_x", type="float", nullable=true)
	 */
	public $posX;

	/**
	 * @var float
	 * @ORM\Column(name="pos_y", type="float", nullable=true)
	 */
	public $posY;

	public function __construct($map, $point)
	{
		$this->map   = $map;
		$this->point = $point;
	}

	/******
	 * === Position
	 */

	/**
	 * @param $x
	 * @param $y
	 */
	public function setPosition($x, $y)
	{
		$this->posX = $x;
		$this->posY = $y;
	}

	/**
	 * @return array[x,y]
	 */
	public function getPosition()
	{
		return ['x' => $this->posX, 'y' => $this->posY];
	}
}