<?php declare(strict_types = 1);

namespace MapPoints\AdminModule\Presenters;

use MapPoints\AdminModule\Components\IGroupFormFactory;
use MapPoints\AdminModule\Components\IGroupsGridFactory;
use MapPoints\AdminModule\Components\IMapFormFactory;
use MapPoints\AdminModule\Components\IMapsGridFactory;
use MapPoints\AdminModule\Components\IPointFormFactory;
use MapPoints\AdminModule\Components\IPointsGridFactory;
use MapPoints\Model\Entities\Group;
use MapPoints\Model\Entities\Map;
use MapPoints\Model\Entities\Point;
use Nette\Application\UI\Form;
use Nette\Http\IResponse;

final class DefaultPresenter extends BasePresenter
{

	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('mapPoints.title.mapPoints'));
		$this->setHeader('mapPoints.title.mapPoints','fa fa-map-marked');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'mapPoints.menu.newPoint',
				'link'  => 'Default:addPoint',
				'ico'   => 'plus',
			], [
				'title' => 'mapPoints.menu.newGroup',
				'link'  => 'Default:addGroup',
				'ico'   => 'plus',
			], [
				'title' => 'mapPoints.menu.newMap',
				'link'  => 'Default:addMap',
				'ico'   => 'plus',
			]
		]]);
	}

	public function actionAddPoint()
	{
		$this->setTitle($this->translator->translate('mapPoints.title.newPoint'));
		$this->setHeader('mapPoints.title.newPoint','fa fa-map-marked');
	}

	public function actionAddGroup()
	{
		$this->setTitle($this->translator->translate('mapPoints.title.newGroup'));
		$this->setHeader('mapPoints.title.newGroup','fa fa-map-marked');
	}

	public function actionAddMap()
	{
		$this->setTitle($this->translator->translate('mapPoints.title.newMap'));
		$this->setHeader('mapPoints.title.newMap','fa fa-map-marked');
	}

	public function actionEditPoint($id)
	{
		$point = $this->em->getRepository(Point::class)->find($id);

		if (!$point)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('mapPoints.title.editPoint'), $point->title);
		$this->setHeader('mapPoints.title.editPoint','fa fa-map-marked');
	}

	public function actionEditGroup($id)
	{
		$group = $this->em->getRepository(Group::class)->find($id);

		if (!$group)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('mapPoints.title.editGroup'), $group->title);
		$this->setHeader('mapPoints.title.editGroup','fa fa-map-marked');
	}

	public function actionEditMap($id)
	{
		$map = $this->em->getRepository(Map::class)->find($id);

		if (!$map)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('mapPoints.title.editMap'), $map->title);
		$this->setHeader('mapPoints.title.editMap','fa fa-map-marked');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentPointsGrid(IPointsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentGroupsGrid(IGroupsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentMapsGrid(IMapsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentPointForm(IPointFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setPoint($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentGroupForm(IGroupFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setGroup($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentMapForm(IMapFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setMap($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function(Form $form) use ($control) {
			if ($form->isSubmitted()->name == 'submit') {
				$this->redirect('default');
			} else if ($form->isSubmitted()->name == 'submitAndEdit') {
				$this->redirect('editMap', $control->getMap()->getId());
			}
		};

		return $control;
	}
}