<?php declare(strict_types = 1);

namespace MapPoints\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use MapPoints\Model\Groups;
use MapPoints\Model\Maps;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Map extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'mapPointsMap';

	/** @var Maps */
	protected $mapsService;

	/** @var Groups */
	protected $groupsService;

	public function __construct(Maps $maps, Groups $groups)
	{
		$this->mapsService   = $maps;
		$this->groupsService = $groups;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$maps = ['' => ''] + $this->mapsService->getEr()->findPairs([], 'title', ['title' => 'ASC']);
		$formContainer->addSelect($this->getName(), $this->getTitle(), $maps);
	}

	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->mapsService->getMapGroupsTree($this->getDefault());
	}
}