<?php declare(strict_types = 1);

namespace MapPoints\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use MapPoints\Model\Maps;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\Http\Session;
use Nette\SmartObject;

class MapListener implements Subscriber
{
	use SmartObject;

	/** @var Cache */
	private $cache;

	/** @var Session */
	private $session;

	protected $fields = false;

	protected static $cleared = false;

	public function __construct(IStorage $cacheStorage, Session $session)
	{
		$this->session = $session;
		$this->cache   = new Cache($cacheStorage, Maps::CACHE_NAMESPACE);
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param static             $entity
	 * @param LifecycleEventArgs $event
	 */
	public function postHandler($entity, LifecycleEventArgs $event)
	{
		if (self::$cleared)
			return;

		$this->cache->clean([
			Cache::TAGS => [Maps::CACHE_NAMESPACE],
		]);

		self::$cleared = true;
	}
}
