<?php declare(strict_types = 1);

namespace MapPoints\Model;

use Core\Model\Helpers\BaseEntityService;
use Gedmo\Tree\Entity\Repository\NestedTreeRepository;
use MapPoints\Model\Entities\Group;

/**
 * Class Groups
 * @package MapPoints\Model
 *
 * @method Group|object|null getReference($id)
 * @method Group[]|null getAll()
 * @method Group|null get($id)
 * @method NestedTreeRepository getEr()
 */
class Groups extends BaseEntityService
{
	protected $entityClass = Group::class;

	// TODO traita
	public function setPublish($id, $state)
	{
		if ($item = $this->get($id)) {
			$item->isPublished = $state;
			$this->em->persist($item)->flush();

			return true;
		}

		return false;
	}

	public function remove($id)
	{
		if ($entity = $this->get($id)) {
			$this->getEr()->removeFromTree($entity);
			$this->em->remove($entity);
			$this->em->flush();

			return true;
		}

		return false;
	}
}