<?php declare(strict_types = 1);

namespace MapPoints\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="map_points__point")
 * @ORM\Entity
 * @ORM\EntityListeners({"MapListener"})
 */
class Point
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="street", type="string", length=255, nullable=true)
	 */
	public $street;

	/**
	 * @var string
	 * @ORM\Column(name="city", type="string", length=255, nullable=true)
	 */
	public $city;

	/**
	 * @var string
	 * @ORM\Column(name="zip", type="string", length=8, nullable=true)
	 */
	public $zip;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1})
	 */
	public $isPublished;

	/**
	 * @var string
	 * @ORM\Column(name="text", type="text", nullable=true)
	 */
	protected $text;

	/**
	 * @var Group
	 * @ORM\ManyToOne(targetEntity="Group", inversedBy="points")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $group;

	/**
	 * @var MapPoint[]
	 * @ORM\OneToMany(targetEntity="MapPoint", mappedBy="point")
	 */
	public $maps;

	public function __construct($title)
	{
		$this->title       = $title;
		$this->isPublished = 1;
		$this->maps        = new ArrayCollection();
	}

	/*****
	 * === Text
	 */

	public function setText($text)
	{
		$this->text = $text && $text != '' ? $text : null;
	}

	public function getText() { return $this->text; }
}
