<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20180801010106 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE map_points__group (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, tree_root INT DEFAULT NULL, title VARCHAR(255) NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, lft INT NOT NULL, lvl INT NOT NULL, rgt INT NOT NULL, INDEX IDX_40EC3BFD727ACA70 (parent_id), INDEX IDX_40EC3BFDA977936C (tree_root), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE map_points__map (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, image VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE map_points__map_point (id INT AUTO_INCREMENT NOT NULL, map_id INT DEFAULT NULL, point_id INT DEFAULT NULL, pos_x DOUBLE PRECISION DEFAULT NULL, pos_y DOUBLE PRECISION DEFAULT NULL, INDEX IDX_218F74B053C55F64 (map_id), INDEX IDX_218F74B0C028CEA2 (point_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE map_points__point (id INT AUTO_INCREMENT NOT NULL, group_id INT DEFAULT NULL, title VARCHAR(255) NOT NULL, street VARCHAR(255) DEFAULT NULL, city VARCHAR(255) DEFAULT NULL, zip VARCHAR(8) DEFAULT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, text LONGTEXT DEFAULT NULL, INDEX IDX_9A898C1CFE54D947 (group_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');

		$this->addSql('ALTER TABLE map_points__group ADD CONSTRAINT FK_40EC3BFD727ACA70 FOREIGN KEY (parent_id) REFERENCES map_points__group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE map_points__group ADD CONSTRAINT FK_40EC3BFDA977936C FOREIGN KEY (tree_root) REFERENCES map_points__group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE map_points__map_point ADD CONSTRAINT FK_218F74B053C55F64 FOREIGN KEY (map_id) REFERENCES map_points__map (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE map_points__map_point ADD CONSTRAINT FK_218F74B0C028CEA2 FOREIGN KEY (point_id) REFERENCES map_points__point (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE map_points__point ADD CONSTRAINT FK_9A898C1CFE54D947 FOREIGN KEY (group_id) REFERENCES map_points__group (id) ON DELETE CASCADE');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE map_points__group DROP FOREIGN KEY FK_40EC3BFD727ACA70');
		$this->addSql('ALTER TABLE map_points__group DROP FOREIGN KEY FK_40EC3BFDA977936C');
		$this->addSql('ALTER TABLE map_points__point DROP FOREIGN KEY FK_9A898C1CFE54D947');
		$this->addSql('ALTER TABLE map_points__map_point DROP FOREIGN KEY FK_218F74B053C55F64');
		$this->addSql('ALTER TABLE map_points__map_point DROP FOREIGN KEY FK_218F74B0C028CEA2');

		$this->addSql('DROP TABLE map_points__group');
		$this->addSql('DROP TABLE map_points__map');
		$this->addSql('DROP TABLE map_points__map_point');
		$this->addSql('DROP TABLE map_points__point');
	}
}
