<?php declare(strict_types = 1);

namespace MapPoints\Model;

use Core\Model\Helpers\BaseEntityService;
use MapPoints\Model\Entities\Point;

/**
 * Class Points
 * @package MapPoints\Model
 *
 * @method Point|object|null getReference($id)
 * @method Point[]|null getAll()
 * @method Point|null get($id)
 */
class Points extends BaseEntityService
{
	protected $entityClass = Point::class;

	// TODO traita
	public function setPublish($id, $state)
	{
		if ($item = $this->get($id)) {
			$item->isPublished = $state;
			$this->em->persist($item)->flush();

			return true;
		}

		return false;
	}
}