<?php declare(strict_types = 1);

namespace MeasuringCodes\Console\Ecomail;

use Doctrine;
use Exception;
use MeasuringCodes\Model\EcoMail;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Tracy\Debugger;

#[AsCommand(name: 'measuringcodes:ecomail:export-customers')]
class ExportCustomers extends Command
{
	public function __construct(
		protected EcoMail $ecoMail,
	)
	{
		parent::__construct();
	}

	protected function configure(): void
	{
		$this->setName('measuringcodes:ecomail:export-customers')
			->addOption('site', null, InputOption::VALUE_REQUIRED)
			->addOption('lang', null, InputOption::VALUE_REQUIRED);
	}

	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('ECOMAIL - Export Customers');

		try {
			ini_set('memory_limit', '5G');
			Debugger::dispatch();

			$this->ecoMail->exportCustomers((string) $input->getOption('site'), (string) $input->getOption('lang'));

			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
