<?php declare(strict_types = 1);

namespace MeasuringCodes\Console;

use Doctrine;
use Exception;
use MeasuringCodes\Model\EcoMail;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Tracy\Debugger;

#[AsCommand(name: 'measuringcodes:ecomail:checkInactive')]
class EcomailCheckInactive extends Command
{
	/** @var EcoMail @inject */
	public $ecoMail = null;

	protected function configure(): void
	{
		$this->setName('measuringcodes:ecomail:checkInactive')
			->addOption('days', null, InputOption::VALUE_REQUIRED)
			->addOption('list', null, InputOption::VALUE_REQUIRED)
			->addOption('site', null, InputOption::VALUE_REQUIRED)
			->addOption('lang', null, InputOption::VALUE_REQUIRED)
			->addOption('tag', null, InputOption::VALUE_OPTIONAL);
	}

	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('ECOMAIL CHECK INACTIVE');

		try {
			ini_set('memory_limit', '5G');
			Debugger::dispatch();

			$this->ecoMail->checkInactive(
				(int) $input->getOption('days'),
				(int) $input->getOption('length'),
				(int) $input->getOption('list'),
				(string) $input->getOption('site'),
				(string) $input->getOption('lang'),
				$input->getOption('tag'),
			);

			$output->writeLn('<info>[OK] - checked</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
