<?php declare(strict_types = 1);

namespace MeasuringCodes\Console\Zbozi;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Helpers\Strings;
use MeasuringCodes\Model\Zbozi\RatingService;
use Nette\Utils\Json;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'measuring-codes:zbozi:zbozi-rating-download')]
class ZboziRatingDownload extends Command
{
	public function __construct(
		protected RatingService          $ratingService,
		protected EntityManagerDecorator $em,
	)
	{
		parent::__construct();
	}

	protected function configure(): void
	{
		$this->setName('measuring-codes:zbozi:zbozi-rating-download');
	}

	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('Zbozi rating download');

		try {
			$conn    = $this->em->getConnection();
			$preKey  = 'measuringCodes';
			$postKey = 'ZboziConversion';
			$params  = $conn->fetchAllAssociative("SELECT `key`, `value` FROM core__setting WHERE `key` LIKE '$preKey%' AND `key` LIKE '%$postKey'");

			foreach ($params as $row) {
				$site = null;
				if ($key = Strings::match($row['key'], "/$preKey(.*?)$postKey/")) {
					$site = Strings::firstLower($key[1]);
				}

				$data = Json::decode($row['value'], forceArrays: true);
				if (
					!$site
					|| !array_key_exists('cs', $data)
					|| !isset($data['cs']['apiKey'], $data['cs']['id_provozovny'])
					|| !$data['cs']['apiKey']
					|| !$data['cs']['id_provozovny']
				) {
					continue;
				}

				$apiKey = $data['cs']['apiKey'];
				$shopId = $data['cs']['id_provozovny'];

				$this->ratingService->downloadRating($site, $apiKey, $shopId);
			}

			$output->writeLn('<info>[OK] - downloaded</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
